function JScrollBox(owner, parent, name, rect, tab)
{
	var self = this,
		_isRightMost = true,
		_isBottomMost = true,
		_disposed = false;

	this.initialize(owner, parent, name, null, null, rect, null, null, null, tab);

	this.methods  = (cmRender | cmLoad | cmSave);
	this.tab      = tab;
	
	this.render = render;
	this.load   = load;
	this.save   = save;
	this.dispose = dispose;

	if (!browser.isIE)
	  this.rect.width += 8;
	
	function render(fs)
	{
	  fs.append('<div class="scrollbox" id="' + self.name + '" style="' + self.rect + '">');

	  self.controls.forEach( function (control)
	  {
	    if (utils.inSet(cmRender, control.methods))
	      fs.append(control.render(fs));
	  }, self);
	
	  fs.append('</div>');
	}
	
	function load()
	{
		var pos = self.checkPosition();
		_isRightMost = pos.isRightMost;
		_isBottomMost = pos.isBottomMost;

		self.controls.forEach( function (control)
		{
			if (utils.inSet(cmLoad, control.methods))
				control.load();
		}, self);

		_setSize();
		if (self.getParentObject().onresize != null)
			self.getParentObject().onresize.attach(_setSize);
		else
			self.getForm().onresize.attach(_setSize);
	}
	
	function save()
	{
		self.controls.forEach( function (control)
		{
			if (utils.inSet(cmSave, control.methods))
				control.save();
		}, self);
	}

	function _setSize()
	{
		if (_isBottomMost)
		{
			var h = parseInt(self.$$().parentNode.style.height); //self.$$().parentNode.clientHeight;
			if (h == 0)
				h = self.$(self.parent).clientHeight;

			h = h - self.rect.top - 15;

			if (h < 10)
				h = 10;

			if (self.$$().clientHeight != h)
				self.$$().style.height = h;
		}
	}


	function dispose()
	{
		if (_disposed)
			return;

		self.disposeChildren();

		self.base.dispose.call(self);
		_disposed = true;
	}

}

JScrollBox.inheritsFrom(ControlBase);

if (typeof(loadNextScript) != 'undefined')
	loadNextScript();